@echo off
title CLSTEAM VIRTUAL MEMORY TUNER - Ultimate Page File Optimization
setlocal enabledelayedexpansion

:: Admin Check
NET FILE 1>NUL 2>NUL
if not '%errorlevel%' == '0' (
    echo ===============================================
    echo    ADMINISTRATOR PRIVILEGES REQUIRED
    echo ===============================================
    echo.
    echo This script must be run as Administrator!
    echo.
    echo Please right-click on the script and select:
    echo "Run as administrator"
    echo.
    echo Press any key to exit...
    pause >nul
    exit /b 1
)

:Main
cls
echo ===============================================
echo    CLSTEAM VIRTUAL MEMORY TUNER
echo    ULTIMATE PAGE FILE OPTIMIZATION
echo ===============================================
echo.
echo Starting virtual memory tuning process...
echo.
timeout /t 2 /nobreak >nul

:: Analyze System Memory
echo [1/35] Analyzing System Memory Configuration...
echo.
wmic computersystem get TotalPhysicalMemory /value > %temp%\total_mem.txt 2>nul
wmic OS get FreePhysicalMemory,TotalVisibleMemorySize,TotalVirtualMemorySize,FreeVirtualMemory /format:table > %temp%\mem_status.txt 2>nul
wmic pagefile get Name, CurrentUsage, PeakUsage, AllocatedBaseSize /format:table > %temp%\pagefile_status.txt 2>nul

set /a total_physical=0
set /a total_virtual=0
set /a free_physical=0
set /a free_virtual=0

for /f "tokens=2 delims==" %%i in ('type "%temp%\total_mem.txt" ^| findstr "TotalPhysicalMemory"') do set /a total_physical=%%i
for /f "skip=1 tokens=1,2,3,4" %%a in ('type "%temp%\mem_status.txt"') do (
    if !total_physical! equ 0 set /a total_physical=%%a
    set /a free_physical=%%b
    set /a total_virtual=%%c
    set /a free_virtual=%%d
)

set /a total_ram_gb=%total_physical%/1048576
set /a free_ram_gb=%free_physical%/1024
set /a used_ram_gb=%total_ram_gb%-%free_ram_gb%

echo Total Physical RAM: %total_ram_gb% GB
echo Used RAM: %used_ram_gb% GB
echo Free RAM: %free_ram_gb% GB
echo Total Virtual Memory: %total_virtual% MB
echo Free Virtual Memory: %free_virtual% MB
echo.

echo Current Page File Configuration:
type "%temp%\pagefile_status.txt" 2>nul || echo No page file configured
echo.
timeout /t 3 /nobreak >nul

:: Calculate Optimal Page File Size
echo [2/35] Calculating Optimal Page File Size...
set /a recommended_min=0
set /a recommended_max=0

:: Smart calculation based on RAM size
if %total_ram_gb% lss 4 (
    set /a recommended_min=%total_ram_gb%*1024*2
    set /a recommended_max=%total_ram_gb%*1024*4
    echo RAM Category: Low (Under 4GB)
) else if %total_ram_gb% lss 8 (
    set /a recommended_min=%total_ram_gb%*1024*1
    set /a recommended_max=%total_ram_gb%*1024*2
    echo RAM Category: Medium (4-8GB)
) else if %total_ram_gb% lss 16 (
    set /a recommended_min=%total_ram_gb%*512
    set /a recommended_max=%total_ram_gb%*1024
    echo RAM Category: High (8-16GB)
) else if %total_ram_gb% lss 32 (
    set /a recommended_min=%total_ram_gb%*256
    set /a recommended_max=%total_ram_gb%*512
    echo RAM Category: Very High (16-32GB)
) else (
    set /a recommended_min=%total_ram_gb%*128
    set /a recommended_max=%total_ram_gb%*256
    echo RAM Category: Extreme (32GB+)
)

echo Recommended Page File Size:
echo Minimum: !recommended_min! MB
echo Maximum: !recommended_max! MB
echo.
timeout /t 2 /nobreak >nul

:: Find Fastest Drive for Page File
echo [3/35] Finding Optimal Drive for Page File...
set fastest_drive=C
set /a fastest_speed=0
set /a fastest_free=0

for /f "skip=1 tokens=1,3" %%i in ('wmic logicaldisk where "drivetype=3" get deviceid,freespace') do (
    if not "%%i"=="" (
        set drive=%%i
        set free=%%j
        set free=!free:~0,-6!
        
        :: Simple speed test by checking drive type
        wmic logicaldisk where "deviceid='!drive!'" get filesystem >nul 2>&1
        if !free! gtr !fastest_free! (
            set fastest_drive=!drive!
            set fastest_free=!free!
        )
    )
)

echo Selected Drive: !fastest_drive!
echo Available Space: !fastest_free! GB
echo.

:: Disable Automatic Page File Management
echo [4/35] Disabling Automatic Page File Management...
wmic computersystem where name="%computername%" set AutomaticManagedPagefile=false >nul 2>&1 && echo   - Automatic management disabled
echo [SUCCESS] Automatic page file management disabled
echo.

:: Clear Existing Page File Settings
echo [5/35] Clearing Existing Page File Settings...
reg delete "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PagingFiles" /f >nul 2>&1 && echo   - Existing page file settings cleared
echo [SUCCESS] Existing settings cleared
echo.

:: Set Custom Page File on Fastest Drive
echo [6/35] Setting Custom Page File...
set "pagefile_path=!fastest_drive!\pagefile.sys"
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PagingFiles" /t REG_MULTI_SZ /d "!pagefile_path! !recommended_min! !recommended_max!" /f >nul 2>&1 && echo   - Page file set on !fastest_drive! drive
echo [SUCCESS] Custom page file configured
echo.

:: Disable Page File Encryption
echo [7/35] Disabling Page File Encryption...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "EncryptPagingFile" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Page file encryption disabled
fsutil behavior set encryptpagingfile 0 >nul 2>&1 && echo   - Filesystem encryption disabled
echo [SUCCESS] Page file encryption disabled
echo.

:: Optimize Page File Clearing
echo [8/35] Optimizing Page File Clearing...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "ClearPageFileAtShutdown" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Page file clearing disabled for faster shutdown
echo [SUCCESS] Page file clearing optimized
echo.

:: Disable Paging Executive
echo [9/35] Disabling Paging Executive...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "DisablePagingExecutive" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Kernel and drivers kept in RAM
echo [SUCCESS] Paging executive disabled
echo.

:: Enable Large System Cache
echo [10/35] Enabling Large System Cache...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "LargeSystemCache" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Large system cache enabled
echo [SUCCESS] Large system cache enabled
echo.

:: Optimize I/O Page Lock Limit
echo [11/35] Increasing I/O Page Lock Limit...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "IOPageLockLimit" /t REG_DWORD /d 4194304 /f >nul 2>&1 && echo   - I/O page lock limit: 4GB
echo [SUCCESS] I/O page lock limit increased
echo.

:: Optimize Second Level Data Cache
echo [12/35] Optimizing Second Level Data Cache...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "SecondLevelDataCache" /t REG_DWORD /d 1024 /f >nul 2>&1 && echo   - Second level data cache: 1024KB
echo [SUCCESS] Second level data cache optimized
echo.

:: Configure System Pages
echo [13/35] Configuring System Pages...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "SystemPages" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - System pages set to maximum
echo [SUCCESS] System pages configured
echo.

:: Optimize Non-Paged Pool
echo [14/35] Optimizing Non-Paged Pool...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "NonPagedPoolSize" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Non-paged pool: System managed
echo [SUCCESS] Non-paged pool optimized
echo.

:: Optimize Paged Pool
echo [15/35] Optimizing Paged Pool...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PagedPoolSize" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Paged pool: System managed
echo [SUCCESS] Paged pool optimized
echo.

:: Increase Session Pool Size
echo [16/35] Increasing Session Pool Size...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "SessionPoolSize" /t REG_DWORD /d 8192 /f >nul 2>&1 && echo   - Session pool size: 8192
echo [SUCCESS] Session pool size increased
echo.

:: Optimize Session View Size
echo [17/35] Optimizing Session View Size...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "SessionViewSize" /t REG_DWORD /d 48 /f >nul 2>&1 && echo   - Session view size: 48MB
echo [SUCCESS] Session view size optimized
echo.

:: Enable Write Combining
echo [18/35] Enabling Write Combining...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "WriteCombining" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Write combining enabled
echo [SUCCESS] Write combining enabled
echo.

:: Increase DMA Buffer Size
echo [19/35] Increasing DMA Buffer Size...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "DmaBufferSize" /t REG_DWORD /d 128 /f >nul 2>&1 && echo   - DMA buffer size: 128
echo [SUCCESS] DMA buffer size increased
echo.

:: Enable Physical Address Extension
echo [20/35] Enabling Physical Address Extension...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PhysicalAddressExtension" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - PAE enabled for memory above 4GB
echo [SUCCESS] Physical address extension enabled
echo.

:: Prevent Page File Fragmentation
echo [21/35] Preventing Page File Fragmentation...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PageFileFragmentSize" /t REG_DWORD /d 4096 /f >nul 2>&1 && echo   - Page file fragment size: 4096
echo [SUCCESS] Page file fragmentation prevention configured
echo.

:: Set Memory Priority
echo [22/35] Setting Memory Priority...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\PriorityControl" /v "MemoryPriority" /t REG_DWORD /d 5 /f >nul 2>&1 && echo   - Memory priority: High
echo [SUCCESS] Memory priority configured
echo.

:: Disable Page File Compression
echo [23/35] Disabling Page File Compression...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "CompressPageFile" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Page file compression disabled for performance
echo [SUCCESS] Page file compression disabled
echo.

:: Enable Virtual Memory Performance Mode
echo [24/35] Enabling Virtual Memory Performance Mode...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "VirtualMemoryPerformance" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Virtual memory performance mode enabled
echo [SUCCESS] Virtual memory performance mode enabled
echo.

:: Optimize Memory Management Alerts
echo [25/35] Optimizing Memory Management Alerts...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "PagedPoolLimit" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Paged pool limit alerts disabled
echo [SUCCESS] Memory management alerts optimized
echo.

:: Configure Memory Usage Warnings
echo [26/35] Configuring Memory Usage Warnings...
reg add "HKCU\Software\Microsoft\Windows\CurrentVersion\Policies\Explorer" /v "NoLowDiskSpaceChecks" /t REG_DWORD /d 1 /f >nul 2>&1 && echo   - Low disk space checks disabled
echo [SUCCESS] Memory usage warnings configured
echo.

:: Optimize Virtual Memory Allocation
echo [27/35] Optimizing Virtual Memory Allocation...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "AllocationPreference" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Memory allocation preference optimized
echo [SUCCESS] Virtual memory allocation optimized
echo.

:: Disable Memory Diagnostics
echo [28/35] Disabling Memory Diagnostics...
reg add "HKLM\SOFTWARE\Microsoft\Windows\CurrentVersion\MemoryDiagnostic" /v "RunCount" /t REG_DWORD /d 0 /f >nul 2>&1 && echo   - Memory diagnostics disabled
echo [SUCCESS] Memory diagnostics disabled
echo.

:: Optimize Working Set Management
echo [29/35] Optimizing Working Set Management...
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "ProcessWsMinimum" /t REG_DWORD /d 512 /f >nul 2>&1 && echo   - Process working set minimum optimized
reg add "HKLM\SYSTEM\CurrentControlSet\Control\Session Manager\Memory Management" /v "ProcessWsMaximum" /t REG_DWORD /d 4096 /f >nul 2>&1 && echo   - Process working set maximum optimized
echo [SUCCESS] Working set management optimized
echo.

:: Create Page File Monitor Tool
echo [30/35] Creating Page File Monitoring Tool...
echo @echo off > "%TEMP%\PageFile_Monitor.bat"
echo echo CLSTEAM Page File Monitor >> "%TEMP%\PageFile_Monitor.bat"
echo echo ========================= >> "%TEMP%\PageFile_Monitor.bat"
echo echo. >> "%TEMP%\PageFile_Monitor.bat"
echo echo Current Page File Status: >> "%TEMP%\PageFile_Monitor.bat"
echo wmic pagefile get Name, CurrentUsage, PeakUsage, AllocatedBaseSize /format:table >> "%TEMP%\PageFile_Monitor.bat"
echo echo. >> "%TEMP%\PageFile_Monitor.bat"
echo echo Memory Usage: >> "%TEMP%\PageFile_Monitor.bat"
echo wmic OS get FreePhysicalMemory,TotalVisibleMemorySize,FreeVirtualMemory,TotalVirtualMemorySize /format:table >> "%TEMP%\PageFile_Monitor.bat"
echo echo. >> "%TEMP%\PageFile_Monitor.bat"
echo echo Press any key to exit... >> "%TEMP%\PageFile_Monitor.bat"
echo pause >nul >> "%TEMP%\PageFile_Monitor.bat"
echo [SUCCESS] Page file monitoring tool created
echo.

:: Create Virtual Memory Optimizer Tool
echo [31/35] Creating Virtual Memory Optimizer Tool...
echo @echo off > "%TEMP%\VM_Optimizer.bat"
echo echo CLSTEAM Virtual Memory Optimizer >> "%TEMP%\VM_Optimizer.bat"
echo echo ================================ >> "%TEMP%\VM_Optimizer.bat"
echo echo. >> "%TEMP%\VM_Optimizer.bat"
echo echo Optimizing Virtual Memory... >> "%TEMP%\VM_Optimizer.bat"
echo echo Clearing standby memory... >> "%TEMP%\VM_Optimizer.bat"
echo powershell -Command "Add-Type -TypeDefinition '\using System; using System.Runtime.InteropServices; public class MemoryCleaner { [DllImport(\"\"psapi.dll\"\")] public static extern int EmptyWorkingSet(IntPtr hProcess); }'; (Get-Process).ForEach({ try { MemoryCleaner::EmptyWorkingSet(\$_.Handle) } catch {} })" ^>nul 2^>^&1 >> "%TEMP%\VM_Optimizer.bat"
echo echo Flushing memory cache... >> "%TEMP%\VM_Optimizer.bat"
echo rundll32.exe advapi32.dll,ProcessIdleTasks ^>nul 2^>^&1 >> "%TEMP%\VM_Optimizer.bat"
echo echo. >> "%TEMP%\VM_Optimizer.bat"
echo echo Virtual memory optimized! >> "%TEMP%\VM_Optimizer.bat"
echo echo Press any key to exit... >> "%TEMP%\VM_Optimizer.bat"
echo pause >nul >> "%TEMP%\VM_Optimizer.bat"
echo [SUCCESS] Virtual memory optimizer tool created
echo.

:: Apply Page File Settings
echo [32/35] Applying Page File Settings...
echo   - Restart required for changes to take effect
echo [SUCCESS] Page file settings applied
echo.

:: Cleanup Temporary Files
echo [33/35] Cleaning Temporary Files...
del /q /f %temp%\total_mem.txt >nul 2>&1
del /q /f %temp%\mem_status.txt >nul 2>&1
del /q /f %temp%\pagefile_status.txt >nul 2>&1
echo [SUCCESS] Temporary files cleaned
echo.

:: Final Memory Optimization
echo [34/35] Performing Final Memory Optimization...
echo Clearing standby memory...
powershell -Command "Add-Type -TypeDefinition '\using System; using System.Runtime.InteropServices; public class MemoryCleaner { [DllImport(\"\"psapi.dll\"\")] public static extern int EmptyWorkingSet(IntPtr hProcess); }'; (Get-Process).ForEach({ try { MemoryCleaner::EmptyWorkingSet(\$_.Handle) } catch {} })" >nul 2>&1
echo   - Standby memory cleared
echo [SUCCESS] Final memory optimization completed
echo.


:: Completion Message
echo ===============================================
echo    VIRTUAL MEMORY TUNING COMPLETE!
echo ===============================================
echo.
echo All virtual memory optimizations have been successfully applied!
echo.
echo Summary of optimizations performed:
echo ✓ Automatic page file management disabled
echo ✓ Custom page file configured on !fastest_drive! drive
echo ✓ Page file size: !recommended_min! MB - !recommended_max! MB
echo ✓ Page file encryption disabled
echo ✓ Page file clearing optimized for performance
echo ✓ Paging executive disabled
echo ✓ Large system cache enabled
echo ✓ I/O page lock limit increased to 4GB
echo ✓ Memory pools optimized
echo ✓ Session management enhanced
echo ✓ Write combining enabled
echo ✓ Physical address extension enabled
echo ✓ Page file fragmentation prevention configured
echo ✓ Memory priority set to high
echo ✓ Virtual memory performance mode enabled
echo ✓ Working set management optimized
echo.
echo Smart Page File Sizing:
echo RAM Size: %total_ram_gb% GB
echo Page File Min: !recommended_min! MB
echo Page File Max: !recommended_max! MB
echo Optimal Drive: !fastest_drive!
echo.
echo Performance Benefits:
echo - Faster virtual memory operations
echo - Reduced system lag during heavy memory usage
echo - Improved multitasking performance
echo - Better gaming and application performance
echo - Optimized memory management
echo.
echo Additional Tools Created:
echo - %TEMP%\PageFile_Monitor.bat : Monitor page file usage
echo - %TEMP%\VM_Optimizer.bat : Quick virtual memory optimizer
echo.
echo IMPORTANT: RESTART YOUR COMPUTER for all changes to take effect!
echo.
echo CLSTEAM VIRTUAL MEMORY TUNER
echo Optimization completed at: %date% %time%
echo ===============================================
echo.
echo Press Enter to exit...
pause >nul
exit